# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdarray import *
from .sdproperty import *
from .sdapiobject import *
from .sdproperty import *
from .sdproperty import *
from .sdapiobject import *
from .apiexception import APIException

class SDDefinition(SDAPIObject):
    """
    Describes a generic definition (of a node, a function, an item, ...) with some common GUI infos and a set of SDProperty
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDDefinition
        """
        super(SDDefinition, self).__init__(APIContext, handle, *args, **kwargs)

    def getId(self) -> str:
        """
        Get the identifier of the definition

        """
        outId = ctypes.c_char_p()
        _res = self.mAPIContext.SDDefinition_getId(self.mHandle, ctypes.byref(outId))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outId.value.decode('utf-8') # type: ignore

    def getLabel(self) -> str:
        """
        Get the label of the definition

        """
        outLabel = ctypes.c_char_p()
        _res = self.mAPIContext.SDDefinition_getLabel(self.mHandle, ctypes.byref(outLabel))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outLabel.value.decode('utf-8') # type: ignore

    def getDescription(self) -> str:
        """
        Get the description of the definition

        """
        outDescription = ctypes.c_char_p()
        _res = self.mAPIContext.SDDefinition_getDescription(self.mHandle, ctypes.byref(outDescription))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outDescription.value.decode('utf-8') # type: ignore

    def getProperties(self, sdPropertyCategory : SDPropertyCategory) -> Optional[SDArray[SDProperty]]:
        """
        Get all properties matching the specified SDPropertyCategory

        :param sdPropertyCategory: The category of the properties
        """
        outSDPropertyArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDDefinition_getProperties(self.mHandle, sdPropertyCategory.value, ctypes.byref(outSDPropertyArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDPropertyArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDPropertyArray.value, ownHandle=True)

    def getPropertyFromId(self, sdPropertyId : str, sdPropertyCategory : SDPropertyCategory) -> Optional[SDProperty]:
        """
        Get property that matches the specified identifier in the specified category

        :param sdPropertyId: The identifier of the property we want to retrieve
        :param sdPropertyCategory: The category of the property
        """
        outSDProperty = ctypes.c_void_p()
        _res = self.mAPIContext.SDDefinition_getPropertyFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), sdPropertyCategory.value, ctypes.byref(outSDProperty))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDProperty, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDProperty.value, ownHandle=True)

